**************************************
*** This do-file creates figure 10 ***
**************************************

clear
clear matrix
set mem 1100m

* !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

use `njdir'nj_respondents_new.dta, clear

local iddur = 1
local iext = 0

if `iext'==0 {
drop if extended_study==1
}

* drop those with less than 2 interviews in baseline study
drop if nweeks_bas<2

replace curweek2ct = curweek2ct-41

gen     weekspaid_allc =  0 if coh==1
replace weekspaid_allc = 10 if coh==2
replace weekspaid_allc = 20 if coh==3
replace weekspaid_allc = 30 if coh==4
replace weekspaid_allc = 40 if coh==5
replace weekspaid_allc = 50 if coh==6
replace weekspaid_allc = 60 if coh==7
replace weekspaid_allc = 70 if coh==8

gen ud = round(udur_wkpd_cal)


* day of first job offer
gen joboffday=.
gen joboffday_ft=.
gen joboffday_pt=.
forvalues x=1(1)26 {
sort id week
quietly by id: replace joboffday = ud[`x'] - 1 if joboffint[`x']==1 & joboffday==. & week==1
quietly by id: replace joboffday = ud[`x'] if joboff7d[`x']==1 & joboffday==. & week==1

quietly by id: replace joboffday_ft = ud[`x'] - 1  if joboffint_ft[`x']==1 & joboffday_ft==. & week==1
quietly by id: replace joboffday_ft = ud[`x'] if joboff7d_ft[`x']==1 & joboffday_ft==. & week==1

quietly by id: replace joboffday_pt = ud[`x'] - 1  if joboffint_pt[`x']==1 & joboffday_pt==. & week==1
quietly by id: replace joboffday_pt = ud[`x'] if joboff7d_pt[`x']==1 & joboffday_pt==. & week==1
}

* day of first and last interview
sort id week
by id: gen dayfirst = ud[1] if week==1
by id: gen daylast  = ud[_N] if week==1


* failure
gen faild = 0
replace faild = 1 if joboffday!=.
gen faild_ft = 0
replace faild_ft = 1 if joboffday_ft!=.
gen faild_pt = 0
replace faild_pt = 1 if joboffday_pt!=.

replace dayfirst = dayfirst-1
if `iddur'==1 & `iext'==0 {
replace daylast  = weekspaid_allc + 15 if daylast>= weekspaid_allc + 15
}

if `iddur'==1 & `iext'==1 {
replace daylast  = weekspaid_allc + 15 if daylast>= weekspaid_allc + 15 & weekspaid_all<60
replace daylast  = weekspaid_allc + 34 if daylast>= weekspaid_allc + 34 & weekspaid_all>=60
}

* dur
gen     dur = joboffday
replace dur = daylast if joboffday==.

gen     dur_ft = joboffday_ft
replace dur_ft = daylast if joboffday_ft==.

gen     dur_pt = joboffday_pt
replace dur_pt = daylast if joboffday_pt==.


drop if week>1

***************************
*** time to first offer ***
***************************


stset dur, failure(faild) enter(time dayfirst) exit(time daylast)
sts graph, failure ylabel(0(0.1)0.5) by(coh) ///
graphregion(c(white)) ///
xlabel(0(20)100) ///
title("Fraction with at least one job offer") ///
xtitle("") legend(off) ///
note("Notes: Survey weights are used. The graph shows the Kaplan-Meier failure estimates of the duration until the first" ///
"job offer. If a person stopped answering the survey, all weeks after the last interview are treated as censored." ///
"For each cohort, only the first 13 weeks are shown. Sample: Baseline study; respondents with at least two interviews.", size(vsmall))
graph export `njdir'timetojoboffer_duration_`iddur'.png, replace hei(1200) wid(1650)
graph export `njdir'timetojoboffer_duration_`iddur'.eps, replace



stop
